/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;

public class ClassIdTasklet
extends Tasklet {
    private static final boolean DEBUG = false;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "ClassIdTasklet");
    private static final short CLASS_ERR = 232;
    private static final short TASKLET_ERROR = 233;
    private static final String TRACE_MASKT = "XFRMOITT";
    private static final String TRACE_MASKF = "XFRMOITF";
    private static final String TRACE_MASKD = "XFRMOITD";

    public void init(Object initData) throws TaskletException {
    }

    public void service(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service()");
        if (request.isNormal() && request != null && !request.isInitialRequest()) {
            String[] result = null;
            ClassId id = (ClassId)request.getData("ClassId");
            try {
                result = ClassIdTasklet.getImplementedClasses(id);
            }
            catch (HException exc) {
                throw new TaskletException(exc);
            }
            response.setData("Result", result);
        }
        if (!response.isResponseSet()) {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public static String[] getImplementedClasses(ClassId id) throws HException {
        String[] result;
        try {
            ArrayList<String> classNames = new ArrayList<String>();
            String className = id.getFullClassName();
            classNames.add(className);
            Class<?> myClass = Class.forName(className);
            ClassIdTasklet.findImplementedClasses(myClass, classNames);
            result = new String[classNames.size()];
            classNames.toArray(result);
        }
        catch (ClassNotFoundException exc) {
            throw new HException(exc);
        }
        return result;
    }

    private static void findImplementedClasses(Class aClass, ArrayList classNames) {
        Class<?>[] interfaces = aClass.getInterfaces();
        for (int ix = 0; ix < interfaces.length; ++ix) {
            classNames.add(interfaces[ix].getName());
            ClassIdTasklet.findImplementedClasses(interfaces[ix], classNames);
        }
        Class superClass = aClass.getSuperclass();
        if (superClass != null) {
            classNames.add(superClass.getName());
            ClassIdTasklet.findImplementedClasses(superClass, classNames);
        }
    }

    public void logException(Throwable thrown) {
        new FrameworkLog(classLogInfo, 233, thrown).log();
    }
}

